/**
 ******************************************************************************
 *
 * @file        MG32x02z_EncoderEC11_API.c
 * @brief       Sample QEI state by TM26. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_EncoderEC11_API.h"
#include "UserEvent.h"
#include "RingBuffer.h"
#include "MG0404A_BSP.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
TM_HandleTypeDef mTM36;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
extern void ble_run(unsigned short interv_adv);

/* External vairables --------------------------------------------------------*/
extern UEvent_HandleTypedef gUEvent;




/**
 *******************************************************************************
 * @brief       Initial H/W Encoder 
 * @param[in]   None
 * @return      None
 *******************************************************************************
 */
void API_EncoderEC11_Init(void)
{
    TM_Encoder_InitTypeDef  TM36Encoder;
    TM_ClockConfigTypeDef   CKConfig;

    // ------------------------------------------------------------------------
    // 1.Initial TM36 timer : counter range is 8K in 48MHz.
    // ------------------------------------------------------------------------
    mTM36.Instance                  = TM36;
    mTM36.Init.TM_CounterMode       = TM_CASCADE_UP;
    mTM36.Init.TM_Period            = 0xFFFF;                   // 12, 18 or 24 Pulses per 360 ?Rotation
    mTM36.Init.TM_Prescaler         = 3;
    mTM36.State                     = MID_TM_STATE_RESET;
    MID_TM_Encoder_Init(&mTM36);

    // ------------------------------------------------------------------------
    // 2.Initial TM36 clock mode.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = 0;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    MID_TM_ConfigClockSource(&mTM36, &CKConfig);  

    // ------------------------------------------------------------------------
    // 3.Start the encoder interface
    // ------------------------------------------------------------------------
    TM36Encoder.EncoderMode         = TM_ENCODERMODE_BOTHEDGE;
    TM36Encoder.EncoderDirection    = TM_ENCODER_DIRECTION_NORMAL;
    TM36Encoder.EncoderReset        = TM_ENCODER_RESET_1T2;
    TM36Encoder.IC0Selection        = MID_TM_INPUTMUX_PIN;
    TM36Encoder.IC1Selection        = MID_TM_INPUTMUX_PIN;
    //MID_TM_Encoder_Start(&hTM36, &TM36Encoder);
    MID_TM_Encoder_Start_IT(&mTM36, &TM36Encoder, TM_IT_QEI_DIRCHANGE);

    __DRV_TM_SET_COUNTER(&mTM36, 0x80);
}

/**
 *******************************************************************************
 * @brief       Get Encoder Position
 * @param[in]   None
 * @return      Encoder Position
 *******************************************************************************
 */
int8_t API_EncoderEC11_GetPosition(void)
{
    int8_t tmp;

    if(__DRV_TM_GET_FLAG(&mTM36, TM_FLAG_DIRECTION) == 0)
        tmp = (int8_t)(__DRV_TM_GET_COUNTER(&mTM36) - 0x80);
    else
        tmp = (int8_t)(__DRV_TM_GET_COUNTER(&mTM36) - 0x80);

    __DRV_TM_SET_COUNTER(&mTM36, 0x80);
    __DRV_TM_CLEAR_FLAG(&mTM36, TM_FLAG_QEI_DIRCHANGE);
    return tmp;
}

/**
 ******************************************************************************
 * 
 * 
 * 
 ******************************************************************************
*/ 
void MID_RTC_PCCallback(RTC_HandleTypeDef* PCCallback_mRTC)
{

    __DRV_RTC_CLEAR_FLAG(PCCallback_mRTC , RTC_STA_PCF);
//    gMenu.RTCEvent = 1;
}

/**
 ******************************************************************************
 * 
 * 
 * 
 ******************************************************************************
*/
//__IO int8_t gQEITemp;
void MID_TM_QEI_DIRCHANGECallback(TM_HandleTypeDef* mTM)
{
    __IO uint8_t lTemp8 = (uint8_t)__DRV_TM_GET_COUNTER(&mTM36);

    //=========================================================
    //Prevent unused argument compilcation warning
    ((void)(mTM));
    
    if(lTemp8 == ((uint8_t)0x80))
        return;

    __DRV_TM_SET_COUNTER(&mTM36, 0x80);

    if(lTemp8 > ((uint8_t)0x80))
    {
        RingBufferU8_WriteByte(&gEventQueue, EC11_LEFTROTATE);
        gIdleCount = MID_GetTick(); // Reload Tick Counter
    }
    else
    {
        RingBufferU8_WriteByte(&gEventQueue, EC11_RIGHTROTATE);
        gIdleCount = MID_GetTick(); // Reload Tick Counter
    }
}

/**
 ******************************************************************************
 * 
 * 
 * 
 ******************************************************************************
*/
static __IO uint8_t KeyDebunceCount = 0;
void MID_EXIC_OFCallback(EXIC_HandleTypeDef* MEXIC_PX)
{
    //==============================================================================
    //Into the AFCallback from EXIC_PA input interrupt.
    if(MEXIC_PX->EXIC_Port == EXIC_PORTA)
    {
        MID_EXIC_ClearITFlag(MEXIC_PX, EXIC_PX_OF);
        if((EXIC->PA_PF.W & EXIC_PA_PF_PA10_PF_mask_w) != 0)
        {
            __DRV_EXIC_CLEAR_PINTRIGGER_EVENTFLAG(&mEXIC_PA, EXIC_PX_PIN10);
            ble_run(0);
        }
        if((EXIC->PA_PF.W & EXIC_PA_PF_PA14_PF_mask_w) != 0)
        {
            __DRV_EXIC_CLEAR_PINTRIGGER_EVENTFLAG(&mEXIC_PA, EXIC_PX_PIN14);
            KeyDebunceCount++;
            if(KeyDebunceCount > 100)
            {
                if((IOMA->CR14.W & PX_CR_INV_mask_w) == 0)
                {
                    RingBufferU8_WriteByte(&gEventQueue, EC11_KEY_Push);
                    gIdleCount = MID_GetTick(); // Reload Tick Counter
                    IOMA->CR14.W = (IOMA->CR14.W | PX_CR_INV_mask_w);
                }
                else
                {
                    RingBufferU8_WriteByte(&gEventQueue, EC11_KEY_Pop);
                    gIdleCount = MID_GetTick(); // Reload Tick Counter
                    IOMA->CR14.W = (IOMA->CR14.W & (~PX_CR_INV_mask_w));
                }
                KeyDebunceCount = 0;
            }
        }
    }
}


